﻿using System.Collections.Generic;
using System.Threading.Tasks;
using Hims.Shared.EntityModels;
using Hims.Shared.UserModels.Filters;

namespace Hims.Domain.Services
{
    /// <summary>
    /// The Exception Log Service interface.
    /// </summary>
    public interface IExceptionLogService
    {
        /// <summary>
        /// The invoke.
        /// </summary>
        /// <param name="userId">
        /// The log From.
        /// </param>
        /// <param name="logRoute">
        /// The log Route.
        /// </param>
        /// <param name="errorMessage">
        /// The error Message.
        /// </param>
        /// <param name="errorDescription">
        /// The error Description.
        /// </param>
        void Invoke(string userId, string logRoute, string errorMessage, string errorDescription);
        
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        Task<IEnumerable<ExceptionLogModel>> FetchAsync(ExceptionLogFilterModel model);
        
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="exceptionLogId">
        /// The model.
        /// </param>
        Task<int> ResolveAsync(int exceptionLogId);
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="exceptionLogId">
        /// The model.
        /// </param>
        Task<IEnumerable<ExceptionLogModel>> GetMethodAsync(string LogPath);
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="exceptionLogId">
        /// The model.
        /// </param>
        Task<IEnumerable<ExceptionLogModel>> GetLogRouteAsync();
        
    }
}
