﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.ProgressReport.Assessments;
    using MedicationInfo = Shared.UserModels.ProgressReport.MedicationInfo;
    using Labs = Shared.UserModels.ProgressReport.Labs;
    using Resource = Hims.Shared.UserModels.Discharge.Resource;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IProgressReportAssessmentsService
    {
        /// <summary>
        /// Fetches the assessments information asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<MedicationInfo.LabFetchModel>> FetchAssessmentsInfoAsync(Labs.FilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// Deletes the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteAsync(DeleteModel model);

        /// <summary>
        /// Fetches the charge types asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource.ViewModel>> FetchAssessmentTypesAsync();

    }
}
