﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Service Service interface.
    /// </summary>
    public interface IServiceService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ServiceModel>> FetchAsync(ServiceFilterModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="serviceIds">
        /// The service Ids.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ServiceModel>> FindAsync(string serviceIds);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ServiceModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ServiceModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="serviceId">
        /// The service id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int serviceId);

        /// <summary>
        /// The modify status async.
        /// </summary>
        /// <param name="serviceId">
        /// The service id.
        /// </param>
        /// <param name="modifiedBy">
        /// The modified By.
        /// </param>
        /// <param name="status">
        /// The status.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(int serviceId, int modifiedBy, bool status);


    }
}
