﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.WebNotification;

    /// <summary>
    /// The web notification service interface.
    /// </summary>
    public interface IWebNotificationService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(WebNotificationModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <param name="BookScanAppointmentId">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(WebNotificationModel model, int BookScanAppointmentId);

        /// <summary>
        /// Gets all roles.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<RoleModel>> GetAllRoles();

        /// <summary>
        /// Fetches the name of the account basedon.
        /// </summary>
        /// <param name="fullName">The full name.</param>
        /// <returns></returns>
        Task<IEnumerable<AccountModel>> FetchAccountBasedonName(string fullName);

        /// <summary>
        /// Fetches the notificatons.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<WebNotificationDisplayModel>> FetchNotificatons(WebNotificationFilterModel model);

        /// <summary>
        /// Updates the read status.
        /// </summary>
        /// <param name="referenceId">The reference identifier.</param>
        /// <param name="modulesMasterId"></param>
        /// <returns></returns>
        Task<int> UpdateReadStatus(int referenceId, int modulesMasterId);
    }
}
