﻿using System;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The role.
    /// </summary>
    public class DischargeModel
    {
        /// <summary>
        /// Gets or sets the discharge instruction identifier.
        /// </summary>
        /// <value>
        /// The discharge instruction identifier.
        /// </value>
        public int DischargeInstructionId { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string DischargeInstructionName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role
        /// </summary>
        public string? CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the Created by Role.
        /// </summary>
        public string? ModifiedByRole { get; set; }

    }
}
