﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class GynEncounterFullTranscriptModel
    {
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        public int GynEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        public DateTime EncounterDate { get; set; }

        /// <summary>
        /// Gets or sets the abdomen.
        /// </summary>
        public string? Abdomen { get; set; }

        /// <summary>
        /// Gets or sets the additional Labs.
        /// </summary>
        public string? AdditionalLabs { get; set; }

        /// <summary>
        /// Gets or sets the birth control.
        /// </summary>
        public string? BirthControl { get; set; }

        /// <summary>
        /// Gets or sets the breast.
        /// </summary>
        public string? Breast { get; set; }

        /// <summary>
        /// Gets or sets the breast screening.
        /// </summary>
        public string? BreastScreening { get; set; }

        /// <summary>
        /// Gets or sets the cancer history.
        /// </summary>
        public string? CancerHistory { get; set; }

        /// <summary>
        /// Gets or sets the cardio vascular.
        /// </summary>
        public string? Cardiovascular { get; set; }

        /// <summary>
        /// Gets or sets the gynHistory.
        /// </summary>
        public string? GynHistory { get; set; }

        /// <summary>
        /// Gets or sets the gynLabs.
        /// </summary>
        public string? GynLabs { get; set; }

        /// <summary>
        /// Gets or sets the gynUltraSound.
        /// </summary>
        public string? GynUltraSound { get; set; }

        /// <summary>
        /// Gets or sets the heent.
        /// </summary>
        public string? Heent { get; set; }

        /// <summary>
        /// Gets or sets the lastBreastUltraSound.
        /// </summary>
        public string? LastBreastUltraSound { get; set; }

        /// <summary>
        /// Gets or sets the lastDexaScan.
        /// </summary>
        public string? LastDexaScan { get; set; }

        /// <summary>
        /// Gets or sets the lastMammogram.
        /// </summary>
        public string? LastMammogram { get; set; }

        /// <summary>
        /// Gets or sets the lastPelvicUltraSound.
        /// </summary>
        public string? LastPelvicUltraSound { get; set; }

        /// <summary>
        /// Gets or sets the lymphatic.
        /// </summary>
        public string? Lymphatic { get; set; }

        /// <summary>
        /// Gets or sets the menopausal History.
        /// </summary>
        public string? MenopausalHistory { get; set; }

        /// <summary>
        /// Gets or sets the Mensutral history.
        /// </summary>
        public string? MensutralHistory { get; set; }

        /// <summary>
        /// Gets or sets the musculo skeletal.
        /// </summary>
        public string? MusculoSkeletal { get; set; }

        /// <summary>
        /// Gets or sets the patient deferred.
        /// </summary>
        public string? PatientDeferred { get; set; }

        /// <summary>
        /// Gets or sets the pelvic.
        /// </summary>
        public string? Pelvic { get; set; }

        /// <summary>
        /// Gets or sets the physical exam.
        /// </summary>
        public string? PhysicalExam { get; set; }

        /// <summary>
        /// Gets or sets the respiratory.
        /// </summary>
        public string? Respiratory { get; set; }

        /// <summary>
        /// Gets or sets the skin.
        /// </summary>
        public string? Skin { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the educations.
        /// </summary>
        public string? Educations { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider no.
        /// </summary>
        public string? ProviderNo { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string? SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string? PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the practice location.
        /// </summary>
        public string? PracticeLocation { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string? Signature { get; set; }

        /// <summary>
        /// Gets or sets the clinic picture.
        /// </summary>
        public string? ClinicPicture { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }
        /// <summary>
        /// Gets or sets the gynea card.
        /// </summary>
        public string? GyneacCard { get; set; }

        /// <summary>
        /// Gets or sets the gynea orders.
        /// </summary>
        public string? GynaecOrders { get; set; }

        /// <summary>
        /// Gets or sets the gynae iui.
        /// </summary>
        public string? GynIUI { get; set; }

        /// <summary>
        /// Gets or sets the gynae visit.
        /// </summary>
        public string? GynaecVisit { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        /// 
        /// <summary>
        /// Gets or sets the gynea card.
        /// </summary>
        public string? Procedure { get; set; }

        /// <summary>
        /// Gets or sets the gynea orders.
        /// </summary>
        public string? GyneacPartner { get; set; }

        /// <summary>
        /// Gets or sets the gynae iui.
        /// </summary>
        public string? ProformaForOasi { get; set; }
        /// <summary>
        /// Gets or sets the gynea card.
        /// </summary>
        public string? FamilyHistory { get; set; }

        /// <summary>
        /// Gets or sets the gynea orders.
        /// </summary>
        public string? ProblemList { get; set; }

        /// <summary>
        /// Gets or sets the gynae iui.
        /// </summary>
        public string? Surgeries { get; set; }
        /// <summary>
        /// Gets or sets the gynea orders.
        /// </summary>
        public string? BirthHistory { get; set; }

        /// <summary>
        /// Gets or sets the gynae iui.
        /// </summary>
        public string? Allergies { get; set; }
        /// <summary>
        /// Gets or sets the gynae iui.
        /// </summary>
        public string? OrderPrescription { get; set; }
        public string FriendlyName { get; set; }
        public string ProviderEmail { get; set; }

        public string UMRNo { get; set; }
        public string Measure { get; set; }
        public string Colposcopic { get; set; }
        public string Ectopic { get; set; }
        public string RefferalOrder { get; set; }
        public string GyneacAdmissionSheet { get; set; }
        public string GyneacSurgery { get; set; }
        public string GyneacDiscargeSummary { get; set; }
        public string SpeacialFeature { get; set; }
        public string ScanAppointmentDetails { get; set; }
        public string Reminder { get; set; }
        public string OutSideTests { get; set; }
        
    }
}