﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The health card model.
    /// </summary>
    public class HealthCardHolderModel
    {
        /// <summary>
        /// Gets or sets the health card identifier.
        /// </summary>
        /// <value>
        /// The health card identifier.
        /// </value>      
        public int HealthCardId { get; set; }

        /// <summary>
        /// Gets or sets the Issued card id .
        /// </summary>

        public int IssueHealthCardId { get; set; }

        /// <summary>
        /// Gets or sets the name of the health card.
        /// </summary>
        /// <value>
        /// The name of the health card.
        /// </value>
        public string? HealthCardName { get; set; }

        /// <summary>
        /// Gets or sets the card number.
        /// </summary>
        /// <value>
        /// The card number.
        /// </value>
        public string CardNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the card Holder
        /// </summary>

        public int PatientId { get; set; }


        /// <summary>
        /// Gets or sets the name of the card Holder
        /// </summary>

        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the name of the family members of card Holder
        /// </summary>
        public string? FamilyMembers { get; set; }

        /// <summary>
        /// Gets or sets the name of the Pay Type Id
        /// </summary>

        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the pay type transcation number
        /// </summary>

        public string? PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the Pay Type Name
        /// </summary>

        public string? PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? CreatedDate { get; set; }


        /// <summary>
        /// Gets or sets the created by.s
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? IssuedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string? CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string? ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the Validity Type.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public char ValidityType { get; set; }

        /// <summary>
        /// Gets or sets the family detail  in card.
        /// </summary>
        public List<HealthCardFamilyModel> FamilyDetails { get; set; }

        /// <summary>
        /// Gets or sets the dependent patient ids.
        /// </summary>
        /// <value>
        /// The dependent patient ids.
        /// </value>
        public string DependentPatientIds { get; set; }

        /// <summary>
        /// Gets or sets the valid till.
        /// </summary>
        /// <value>
        /// The valid till.
        /// </value>
        public DateTime ValidTill { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }
    }
}
