﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The Transaction Model.
    /// </summary>
    public class TransactionModel
    {
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

       
        /// <summary>
        /// Gets or sets the Transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTransaction id.
        /// </summary>
        public int AppointmentTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the Refund Amount id.
        /// </summary>
       // public long RefundAmount { get; set; }

        /// <summary>
        /// Gets or sets the payment id.
        /// </summary>
        public int PaymentId { get; set; }    

        /// <summary>
        /// Gets or sets the appointment Id //Respective id .
        /// </summary>
        public int AppointmentId { get; set; }

        // <summary>
        /// Gets or sets the transaction date .
        /// </summary>
        public DateTime TransactionDate { get; set; }

        /// <summary>
        /// Gets or sets the salucro status code.
        /// </summary>
        public string SalucroStatusCode { get; set; }
        /// <summary>
        /// Gets or sets the  salucro Transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the  salucro Transaction id.
        /// </summary>
        public string ReceiptTypeName { get; set; }


        /// <summary>
        /// Gets or sets the  ReceiptAreaType
        /// </summary>
        public string ReceiptAreaType { get; set; }
        /// <summary>
        /// Gets or sets the  PaymentType
        /// </summary>
        public string PaymentType { get; set; }

        /// <summary>
        /// Gets or sets the  salucro amount
        /// </summary>
        public long SettledAmount { get; set; }

        /// <summary>
        /// Gets or sets the  Receipt amount
        /// </summary>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the Area /Module id/ReceiptAreaTypeId.
        /// </summary>
        public int AreaId { get; set; }

        /// <summary>
        /// Gets or sets the salucro status code.
        /// </summary>
        public string VoucherNumber { get; set; }

        /// <summary>
        /// Gets or sets the received via detail.
        /// </summary>
        public string ReceivedIn { get; set; }
        /// <summary>
        /// Gets or sets the sender via detail.
        /// </summary>
        public string SendedVia { get; set; }

        /// <summary>
        /// Gets or sets the  Receipt amount
        /// </summary>
        public double AppDiscount  { get; set; }
        /// <summary>
        /// Gets or sets the  Receipt amount
        /// </summary>
        public double AppAmount { get; set; }

        /// <summary>
        /// Gets or sets the payment id.
        /// </summary>
        public int ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the pay status.
        /// </summary>
        public char? PayStatus { get; set; }

    }
}
