﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The auditLog.
    /// </summary>
    public class WalletModel
    {
        /// <summary>
        /// Gets or sets the wallet id.
        /// </summary>
        public int WalletId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the credited amount.
        /// </summary>
        public double? CreditedAmount { get; set; }

        /// <summary>
        /// Gets or sets the debited amount.
        /// </summary>
        public double? DebitedAmount { get; set; }

        /// <summary>
        /// Gets or sets the credited reason.
        /// </summary>
        public string? CreditedFor { get; set; }

        /// <summary>
        /// Gets or sets the debited amount.
        /// </summary>
        public double? TotalDebits { get; set; }

        /// <summary>
        /// Gets or sets the credited reason.
        /// </summary>
        public double? TotalCredits { get; set; }

        /// <summary>
        /// Gets or sets the available credits.
        /// </summary>
        public double? TotalAvailable { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
    }
}