﻿namespace Hims.Shared.UserModels
{
    using Library.Enums;

    /// <summary>
    /// The encounter modify model.
    /// </summary>
    public class BehavioralModifyModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int BehavioralHealthId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public BehavioralHealthType Type { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string JsonString { get; set; }
    }
}
