﻿namespace Hims.Shared.UserModels.ChargeManagement
{
    using Hims.Shared.UserModels.ChargeModule;
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The provider profile info model.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public int DepartmentId { get; set; }
        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the charge group identifier.
        /// </summary>
        /// <value>
        /// The charge group identifier.
        /// </value>
        public int ChargeGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge group.
        /// </summary>
        /// <value>
        /// The name of the charge group.
        /// </value>
        public string ChargeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public int ChargeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge.
        /// </summary>
        /// <value>
        /// The name of the charge.
        /// </value>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ViewModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the repeat type identifier.
        /// </summary>
        /// <value>
        /// The repeat type identifier.
        /// </value>
        public int? RepeatTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the repeat type.
        /// </summary>
        /// <value>
        /// The name of the repeat type.
        /// </value>
        public string RepeatTypeName { get; set; }

        /// <summary>
        /// Gets or sets the automatic type identifier.
        /// </summary>
        /// <value>
        /// The automatic type identifier.
        /// </value>
        public int? AutomaticTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the automatic type.
        /// </summary>
        /// <value>
        /// The name of the automatic type.
        /// </value>
        public string AutomaticTypeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is special doctor.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is special doctor; otherwise, <c>false</c>.
        /// </value>
        public int? ChargeTypeId { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        /// <value>
        /// The unit.
        /// </value>
        public int Unit { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the charges.
        /// </summary>
        /// <value>
        /// The charges.
        /// </value>
        public List<ChargeModuleDetailsModel> Charges { get; set; }
    }
}