﻿using System.Text.Json.Serialization;

namespace Hims.Shared.UserModels.Common
{
    /// <summary>
    /// The Generic Status
    /// </summary>
    public enum GenericStatus
    {
        /// <summary>
        /// The success
        /// </summary>
        Success = 1,

        /// <summary>
        /// The information
        /// </summary>
        Info = 2,

        /// <summary>
        /// The warning
        /// </summary>
        Warning = 3,

        /// <summary>
        /// The error
        /// </summary>
        Error = 4
    }

    /// <summary>
    /// The common response.
    /// </summary>
    public class GenericResponse
    {
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        [JsonConverter(typeof(JsonStringEnumConverter))]
        public GenericStatus Status { get; set; }

        /// <summary>
        /// Gets or sets the content.
        /// </summary>
        public object Data { get; set; }

        /// <summary>
        /// Gets or sets the response.
        /// </summary>
        public string Message { get; set; }
    }
}
