﻿namespace Hims.Shared.UserModels.DemandBook
{
    using System;

    /// <summary>
    /// The pharmacy product.
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int DemandBookId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the required quantity.
        /// </summary>
        public int? RequiredQty { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets a active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the Pharmacy Log type.
        /// </summary>
        public int? PharmacyLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacyLog code.
        /// </summary>
        public string? LogDescription { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the patientName.
        /// </summary>
        public string? PatientName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; } = string.Empty;
        
    }
}
