﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The Specialization filter model.
    /// </summary>
    public class SpecializationFilterModel
    {
        /// <summary>
        /// Gets or sets the Specialization id.
        /// </summary>        
        public int? SpecializationId { get; set; }
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>        
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string? SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the name of the consultationtype.
        /// </summary>
        /// <value>
        /// The name of the consultationtype.
        /// </value>
        public string? ConsultationtypeName { get; set; }

        /// <summary>
        /// Gets or sets the Icon name.
        /// </summary>
        public string? IconName { get; set; }

        /// <summary>
        /// Gets or sets the url.
        /// </summary>
        public string? Url { get; set; }

        /// <summary>
        /// Gets or sets the specialization description.
        /// </summary>
        public string? SpecializationDescription { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the rejected comments.
        /// </summary>
        public int? ModifiedBy { get; set; }
       
        /// <summary>
        /// Gets or sets the rejected comments.
        /// </summary>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the rejected comments.
        /// </summary>
        public string? AccountFullName { get; set; }

        /// <summary>
        /// Gets or sets the rejected comments.
        /// </summary>
        public string? ProviderName { get; set; }
    }
}
