﻿namespace Hims.Shared.UserModels.FinalBill
{
    /// <summary>
    /// The receipt model
    /// </summary>
    public class FilterModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the RoleId.
        /// </summary>
        public short? RoleId { get; set; }
        /// <summary>
        /// Gets or sets the RollName.
        /// </summary>
        public string? RollName { get; set; }
        /// <summary>
        /// Gets or sets the FullName.
        /// </summary>
        public string? FullName { get; set; }
        /// <summary>
        /// Gets or sets the final bill identifier.
        /// </summary>
        /// <value>
        /// The final bill identifier.
        /// </value>
        public int? FinalBillId { get; set; }

        /// <summary>
        /// Gets or sets the inserte comments.
        /// </summary>
        public int? ModifiedBy { get; set; }

    }
}
