﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The inventory purchase bill model.
    /// </summary>
    public class InventoryPurchaseBillModel
    {
        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int ProductId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public int? Free { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        public double TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the role id .
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }
    }
}
