﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;

    /// <summary>
    /// The request laboratory.
    /// </summary>
    public class RequestLaboratory
    {
        /// <summary>
        /// Gets or sets the lab code.
        /// </summary>
        public string LabCode { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the lab booking header id.
        /// </summary>
        public int? LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public int? LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking package detail id.
        /// </summary>
        public int? LabBookingPackageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the verified by.
        /// </summary>
        public int? VerifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the lab package id.
        /// </summary>
        public int? LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the update all.
        /// </summary>
        public string UpdateAll { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public string RoleId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public string CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the from date .
        /// </summary>
       // public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
      //  public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the from date .
        /// </summary>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the request date.
        /// </summary>
        public DateTime? RequestDate { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the verified by name.
        /// </summary>
        public string VerifiedByName { get; set; }
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string PackageName { get; set; }

        /// <summary>
        /// Gets or sets the payment type.
        /// </summary>
        public string PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public string? PackageId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
      //  public string SelectedFromDate { get; set; }
        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
     //   public string SelectedToDate { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public DateTime? SelectedFromDate { get; set; }
        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public DateTime? SelectedToDate { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the Location Id .
        /// </summary>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the Pay Type id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the barcode name.
        /// </summary>
        public string Barcode { get; set; }
        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public Array? LabBookingDetailIds { get; set; }

    }
}
