﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels
{
#pragma warning disable CS1591 // Missing XML comment for publicly visible type or member
    public class OTRoomAvailabilityInsertModel
#pragma warning restore CS1591 // Missing XML comment for publicly visible type or member
    {
        //OTRoomAvailabilityId", "OTRoomId", "Availability", "LocationId", "Active", "CreatedBy", "CreatedDate", "ModifiedBy", "ModifiedDate", "FromDate",
        //    "ToDate", "AvailableDays", "FromTime", "ToTime"

        /// <summary>
        /// Gets or sets the scan machine availability id.
        /// </summary>
        public int OTRoomAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the scan machine master id.
        /// </summary>
        public int OTRoomId { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDays { get; set; }

        /// <summary>
        /// Gets or sets the machine name.
        /// </summary>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the Availability.
        /// </summary>
        public string Availability { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public DateTime FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public DateTime ToDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string Slots { get; set; }
        
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }
    }
}

/// <summary>
/// The SLot Model Test.
/// </summary>
public class OTRoomModelTest
{
    /// <summary>
    /// Gets or sets the from time
    /// </summary>
    public string FromTime { get; set; }

    /// <summary>
    /// Gets or sets the to time.
    /// </summary>
    public string ToTime { get; set; }

    /// <summary>
    /// Gets or sets the created by name.
    /// </summary>
    public string CreatedByName { get; set; }

    ///// <summary>
    ///// Gets or sets the reference break id.
    ///// </summary>
    //public int? ScanAvailabilityStatus { get; set; }

    ///// <summary>
    ///// Gets or sets the reference block id.
    ///// </summary>
    //public int? ScanAvailabilityReason { get; set; }

}
