﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The pharmacy ware house model.
    /// </summary>
    public class PharmacyWareHouseModel
    {
        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>       
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the retail store count.
        /// </summary>
        /// <value>
        /// The retail store count.
        /// </value>
        public int? RetailStoreCount { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the allowed account identifier.
        /// </summary>
        /// <value>
        /// The allowed account identifier.
        /// </value>
        public string AllowedAccountId { get; set; }

        /// <summary>
        /// Gets or sets the allowed users.
        /// </summary>
        /// <value>
        /// The allowed users.
        /// </value>
        public List<AllowedAccount> AllowedUsers { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="PharmacyWareHouseModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the userBasedStore.
        /// </summary>
        public int? userBasedStore { get; set; }

        /// <summary>
        /// Gets or sets the retail store.
        /// </summary>
        /// <value>
        /// The retail store.
        /// </value>
        public List<RetailPharmacyModel> RetailStore { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the central warehouse location identifier.
        /// </summary>
        /// <value>
        /// The central warehouse location identifier.
        /// </value>
        public int? CentralWarehouseLocationId { get; set; }

        /// <summary>
        /// Gets or sets the central warehouse location.
        /// </summary>
        /// <value>
        /// The central warehouse location.
        /// </value>
        public string CentralWarehouseLocation { get; set; }

        /// <summary>
        /// Gets or sets the location flag.
        /// </summary>
        /// <value>
        /// The location flag.
        /// </value>
        public bool? LocationFlag { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is uploaded.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is uploaded; otherwise, <c>false</c>.
        /// </value>
        public bool IsUploaded { get; set; }

        /// <summary>
        /// Gets or sets the warehouse ids.
        /// </summary>
        /// <value>
        /// The warehouse ids.
        /// </value>
        public string WarehouseIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        public bool NoLocation { get; set; }
    }

    /// <summary>
    /// The allowed account.
    /// </summary>
    public class AllowedAccount
    {
        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the module department user identifier.
        /// </summary>
        /// <value>
        /// The module department user identifier.
        /// </value>
        public int ModuleDepartmentUserId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the name of the role.
        /// </summary>
        /// <value>
        /// The name of the role.
        /// </value>
        public string RoleName { get; set; }
    }
}
