﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.PharmacyIndent
{
    /// <summary>
    /// The pharmacy department indent header.
    /// </summary>
    public class PharmacyDepartmentIndentHeaderModel
    {
        /// <summary>
        /// Gets or sets the pharmacy department indent header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent header identifier.
        /// </value>

        public long PharmacyDepartmentIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        /// <value>
        /// The required date.
        /// </value>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department identifier.
        /// </value>
        public int? PharmacyDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the approved ware house identifier.
        /// </summary>
        /// <value>
        /// The approved ware house identifier.
        /// </value>
        public int? ApprovedWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the approved retail store identifier.
        /// </summary>
        /// <value>
        /// The approved retail store identifier.
        /// </value>
        public int? ApprovedRetailStoreId { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<PharmacyDepartmentIndentDetailModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }


        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy identifier.
        /// </summary>
        /// <value>
        /// The retail pharmacy identifier.
        /// </value>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the name of the approved by.
        /// </summary>
        /// <value>
        /// The name of the approved by.
        /// </value>
        public string? ApprovedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the approved retail.
        /// </summary>
        /// <value>
        /// The name of the approved retail.
        /// </value>
        public string? ApprovedRetailName { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        /// <value>
        /// The approved date.
        /// </value>
        public DateTime? ApprovedDate { get; set; }
        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        /// <value>
        /// The from date.
        /// </value>
        public string? FromDate { get; set; }
        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        /// <value>
        /// The to date.
        /// </value>
        public string? ToDate { get; set; }
        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        public string? Type { get; set; }

        public string From { get; set; }
    }
}
