﻿namespace Hims.Shared.UserModels.ProgressReport.Diet
{
    using System;

    /// <summary>
    /// The view model.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the progress report vitals id.
        /// </summary>
        public int ProgressReportDietId { get; set; }

        /// <summary>
        /// Gets or sets the progress report id.
        /// </summary>
        public int ProgressReportId { get; set; }

        
        /// <summary>
        /// Gets or sets the vital type id.
        /// </summary>
        public int MealTypeId { get; set; }
        
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the meal type.
        /// </summary>
        public string MealType { get; set; }

        /// <summary>
        /// Gets or sets the meal instruction.
        /// </summary>
        public string MealInstruction { get; set; }

        /// <summary>
        /// Gets or sets the meal instruction.
        /// </summary>
        public string DietInstructions { get; set; }

        /// <summary>
        /// Gets or sets the stop reason.
        /// </summary>
        public string StopReason { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? EndDate { get; set; }

    }
}
