﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.ProviderAvailability
{

    /// <summary>
    /// The coupon.
    /// </summary>
    public class FilterAvailabilityViewModel
    {
        public int? ProviderAvailabilityId { get; set; }
        public int? ProviderId { get; set; }
        public string? ProviderName { get; set; }
        public int? LocationId { get; set; }
        public int? ConsultationTypeId { get; set; }

        public string? ConsultationTypeName { get; set; }
        public string? StartDate { get; set; }
        public string? EndDate { get; set; }
        public int? ProviderAvailabilitySlotId { get; set; }
        public int? SpecializationId { get; set; }
        public string? SpecializationName { get; set; }
        public string? AvailableDay { get; set; }

        public string? StartTime { get; set; }
        public string? EndTime { get; set; }

        public int? ProviderAvailabilityVisitTypeId { get; set; }
        public int? VisitTypeId { get; set; }
        public string? VisitorName { get; set; }
        public int? Duration { get; set; }
        public int? FreeFollowUpDays { get; set; }
        public int? FreeFollowUpDaysLimit { get; set; }



        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfNewPatient { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        public string? OptionalText { get; set; }
		public string? Value { get; set; }
        public string? OptionalText2 { get; set; }

        public string? AvailabilityStartDateTime { get; set; }

        public string? AvailabilityEndDateTime { get; set; }

        public string? AvailableDate { get; set; }

        public bool? Flag { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? LeaveStartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? LeaveEndDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool IsLeave { get; set; }

        /// <summary>
        /// Gets or sets the leave.
        /// </summary>
        public string? Leave { get; set; }

        /// <summary>
        /// Gets or sets the provider leave id.
        /// </summary>
        public long ProviderLeaveId { get; set; }

        /// <summary>
        /// Gets ors sets the reason.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfOfflinePatient { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or sets the break type.
        /// </summary>
        public string? BreakType { get; set;}

        /// <summary>
        /// Gets or sets the provider break id.
        /// </summary>
        public int? ProviderBreakId { get; set; }

        /// <summary>
        /// Gets or sets the break block.
        /// </summary>
        public string? BreakBlock { get; set; }

        /// <summary>
        /// Gets or sets the new patient slots.
        /// </summary>
        public int? NewPatientSlots { get; set; }

        /// <summary>
        /// Gets or sets the offline slots.
        /// </summary>
		public int? OfflineSlots { get; set; }

        /// <summary>
        /// Gets or sets the general slots.
        /// </summary>
        public int? GeneralSlots { get; set; }

        /// <summary>
        /// Gets or sets the total slots.
        /// </summary>
        public int? TotalSlots { get; set; }

        /// <summary>
        /// Gets or sets the specialization duration.
        /// </summary>
        public int? SpecializationDuration { get; set; }

        /// <summary>
        /// Gets or sets the doctor week id.
        /// </summary>
        public int? DoctorWeekId { get; set; }
    }

}
