﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The provider list item model.
    /// </summary>
    public class ProviderListItemModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the experience.
        /// </summary>
        public double? Experience { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        public string Specializations { get; set; }

        /// <summary>
        /// Gets or sets the services.
        /// </summary>
        public string Services { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        public string Location { get; set; }

        /// <summary>
        /// Gets or sets the consultation duration.
        /// </summary>
        public short? ConsultationDuration { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public decimal? ConsultationCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine duration.
        /// </summary>
        public short? TelemedicineDuration { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public decimal? TelemedicineCharges { get; set; }

        /// <summary>
        /// Gets or sets the currency symbol
        /// </summary>
        public string CurrencySymbol { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the profile image url.
        /// </summary>
        public string ProfileImageUrl { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDays { get; set; }

        /// <summary>
        /// Gets or sets the availability.
        /// </summary>
        public string Availability { get; set; }

        /// <summary>
        /// Gets or sets the languages.
        /// </summary>
        public string Languages { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether loading.
        /// </summary>
        public bool Loading { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public List<VisitChargeModel> ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the is telemedicine.
        /// </summary>
        public bool? IsTelemedicine { get; set; }

        /// <summary>
        /// Gets or sets the is online consultation.
        /// </summary>
        public bool? IsOnlineConsultation { get; set; }

        /// <summary>
        /// Gets or sets the consultatio type id.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the provider availabilty id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the available day.
        /// </summary>
        public string AvailableDay { get; set; }

        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public string StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public string EndTime { get; set; }

        /// <summary>
        /// Gets or sets the free follow up days.
        /// </summary>
        public int? FreeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the free follow up days limit.
        /// </summary>
        public int? FreeFollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the consultation name.
        /// </summary>
        public string ConsultationName { get; set; }
    }
}