﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.Scan.ScanAppointment
{
    /// <summary>
    /// The book scan appointment.
    /// </summary>
    public class FilterModel
    {
        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public string ScanMachineMasterIds { get; set; }

        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public string? ScanMachineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public string? ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public int? BookScanAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the slot duration.
        /// </summary>
        public int? SlotDuration { get; set; }

        /// <summary>
        /// Gets or sets the slot duration.
        /// </summary>
        public int? LocationId { get; set; }


        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? AppointmentEndDate { get; set; }

        /// <summary>
        /// Gets or sets the calendar view
        /// </summary>
        public string? CalendarView { get; set; }

        /// <summary>
        /// Gets or sets the calendar view
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the calendar view
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the appointment status.
        /// </summary>
        public bool AppointmentStatus { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        public List<AppFilterModel> Filter { get; set; }

    }

    /// <summary>
    /// The App filter model.
    /// </summary>
    public class AppFilterModel
    {
       
        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; }

    }
}
