﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Slots
{
    public class SlotRequest
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets the slot date.
        /// </summary>
        public string SlotDate { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the visitType id.
        /// </summary>
        public int? VisitTypeId { get; set; }
        /// <summary>
        /// Gets or sets the offset.
        /// </summary>
        public string Offset { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets time zone.
        /// </summary>
        public string TimeZone { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets time.
        /// </summary>
        public string Time { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }
        /// <summary>
        /// Gets or sets location id.
        /// </summary>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets consulation type id.
        /// </summary>
        public int? ConsultationTypeId { get; set; }
        /// <summary>
        /// Gets or sets the providerAvailabilityid.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }
        /// <summary>
        /// Gets or sets the chargeTypes Id.
        /// </summary>
        public int? ChargeTypesId { get; set; }
        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }
        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }
        /// <summary>
        /// Gets or sets the count.
        /// </summary>
        public int? Count { get; set; }
        /// <summary>
        /// Gets or sets the surgery id.
        /// </summary>
        public int? SurgeryId { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public string? AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the session id.
        /// </summary>
        public int? SessionTypeId { get; set; }
    }
}
