﻿namespace Hims.Shared.UserModels.UserExcel
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The excel upload history.
    /// </summary>
    public class UserExcelHistoryModel
    {
        /// <summary>
        /// Gets or sets the users.
        /// </summary>
        public List<RawUserModel> Users { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the user excel history id.
        /// </summary>        
        public int UserExcelHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by.
        /// </summary>
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the sheet name.
        /// </summary>
        public string? SheetName { get; set; }

        /// <summary>
        /// Gets or sets the sheet name.
        /// </summary>
        public string? UploadedByName { get; set; }

        /// <summary>
        /// Gets or sets the sheet type
        /// </summary>
        public string? SheetType { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the country Id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or sets the added users.
        /// </summary>
       
        public string AddedUsers { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int? RoleId { get; set; }
    }
}
