﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class DoctorSpecializationMap
    {
        /// <summary>
        /// Gets or sets the doctor specialization map identifier.
        /// </summary>
        /// <value>
        /// The doctor specialization map identifier.
        /// </value>
        [Key, Identity]
        public long DoctorSpecializationMapId { get; set; }

        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation type identifier.
        /// </summary>
        /// <value>
        /// The consultation type identifier.
        /// </value>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the follow up days.
        /// </summary>
        /// <value>
        /// The follow up days.
        /// </value>
        public int? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the visits.
        /// </summary>
        /// <value>
        /// The visits.
        /// </value>
        public int? FollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }
    }
}
