﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using System.Text;

    /// <summary>
    /// The lab patient parameter.
    /// </summary>
    public class LabPatientParameter
    {
        /// <summary>
        /// Gets or sets the lab patient parameter id.
        /// </summary>
        [Key, Identity]
        public int LabPatientParameterId { get; set; }

        /// <summary>
        /// Gets or sets the lab detail id.
        /// </summary>
        public int LabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the test param result.
        /// </summary>
        public string TestParamResult { get; set; }

        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking package detail id.
        /// </summary>
        public int? LabBookingPackageDetailId { get; set; }
    }
}
