﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The service.
    /// </summary>
    public class Service
    {
        /// <summary>
        /// Gets or sets the service id.
        /// </summary>
        [Key, Identity]
        public int ServiceId { get; set; }

        /// <summary>
        /// Gets or sets the service name.
        /// </summary>
        public string ServiceName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the serviceJson.
        /// </summary>
        public string ServiceJson { get; set; }

        /// <summary>
        /// Gets or sets the serviceIconId.
        /// </summary>
        public int? ServiceIconId { get; set; }

        /// <summary>
        /// Gets or sets the serviceIconId.
        /// </summary>
        public int? Priority { get; set; }
    }
}
