﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Hims.Shared.UserModels.Vendors;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary>
    /// The SupplierService interface.
    /// </summary>
    public interface ISupplierService
    {
        /// <summary>
        /// The insert supplier async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertSupplierAsync(SupplierModel model);

        /// <summary>
        /// The update supplier async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateSupplierAsync(SupplierModel model);

        /// <summary>
        /// The delete supplier async.
        /// </summary>
        /// <param name="supplierId">
        /// The supplier id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteSupplierAsync(int supplierId);

        /// <summary>
        /// The fetch all async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<SupplierModel>> FetchAllAsync(SupplierModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<SupplierModel> FetchAsync(SupplierModel model);

        /// <summary>
        /// The add supplier product async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddSupplierProductAsync(SupplierProductModel model);

        /// <summary>
        /// The supplier pharmacy product async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProductModel>> FetchSupplierPharmacyProduct(ProductModel model);

        /// <summary>
        /// The supplier pharmacy product async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public Task<IEnumerable<SupplierModel>> FetchEmailSupplierAsync(SupplierModel model);

        /// <summary>
        /// Adds the suplier account asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddSuplierAccountAsync(SupplierModel model);

        /// <summary>
        /// Adds the product rate list asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddProductRateListAsync(SupplierNewProductModel model);

        /// <summary>
        /// Fetches the rate cards asynchronous.
        /// </summary>
        /// <param name="supplierId">The supplier identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<SupplierNewProductModel>> FetchRateCardsAsync(int supplierId);

        /// <summary>
        /// Checks if date range already exists.
        /// </summary>
        /// <param name="product">The product.</param>
        /// <returns></returns>
        Task<int> CheckIfDateRangeAlreadyExists(SupplierNewProductModel product);
    }
}
