﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The appointment filter model.
    /// </summary>
    public class AppointmentFilterModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public string? Ids { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public string? SIds { get; set; }


        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the Visit type.
        /// </summary>
        public int? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the Visit type.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string? AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string? EncounterType { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the column.
        /// </summary>
        public string? Column { get; set; }

        /// <summary>
        /// Gets or sets the sort.
        /// </summary>
        public bool? Sort { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the is follow up appointment.
        /// </summary>
        public int? IsFollowUpAppointment { get; set; }

        /// <summary>
        /// Gets or sets the location
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the queue status.
        /// </summary>
        /// <value>
        /// The queue status.
        /// </value>
        public int QueueStatusId { get; set; }

        /// <summary>
        /// Gets or sets the is referredby.
        /// </summary>
        public string? Name { get; set; }

        /// <summary>
        /// Gets or sets the pay type id 
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the consultation type id.
        /// </summary>
        public int? ConsultationTypeId {get; set;}

        /// <summary>
        /// Gets or sets the pay type id 
        public string? ResultsType { get; set; }

        /// <summary>
        /// Gets or sets the pay type id 
        public string? Today { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        /// <value>
        /// The payment status.
        /// </value>
        public bool? PaymentStatus { get; set; }
        /// <summary>
        /// Gets or sets the role id 
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the cubicle identifier.
        /// </summary>
        /// <value>
        /// The cubicle identifier.
        /// </value>
        public int? CubicleId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the Visit type.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public bool isMobile { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// used to see wheather user want to get appointments 
        /// </summary>
        public bool pagination { get; set; }
        public object PaymentType { get; set; }
        public object SpecializationId { get; set; }
    }
}
