﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The country.
    /// </summary>
    public class Country
    {
        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        [Key, Identity]
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the country name.
        /// </summary>
        public string CountryName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string CountryCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the iso code.
        /// </summary>
        public string ISOCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the sms url.
        /// </summary>
        public string? SMSUrl { get; set; }

        /// <summary>
        /// Gets or sets the sms from.
        /// </summary>
        public string? SMSFrom { get; set; }

        /// <summary>
        /// Gets or sets the sms authorization.
        /// </summary>
        public string? SMSAuthorization { get; set; }

        /// <summary>
        /// Gets or sets the sms username.
        /// </summary>
        public string? SMSUsername { get; set; }

        /// <summary>
        /// Gets or sets the Currency.
        /// </summary>
        public string Currency { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Currency symbol.
        /// </summary>
        public char CurrencySymbol { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}