﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary> The chat.</summary>
    public class MasterBill
    {
        /// <summary>
        /// Gets or sets the Master bill identifier.
        /// </summary>
        /// <value>
        /// The master bill identifier.
        /// </value>
        [Key, Identity]
        public int MasterBillId { get; set; }

        /// <summary>
        /// Gets or sets the module identifier.
        /// </summary>
        /// <value>
        /// The module identifier.
        /// </value>
        public int ModuleId { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        /// <value>
        /// The bill date.
        /// </value>
        public DateTime? BillDate { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the bill status type id.
        /// </summary>
        /// <value>
        /// The the bill status type id.
        /// </value>
        public int? BillStatusTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="MasterBill"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double NetTotal { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Tax { get; set; }

        /// <summary>
        /// Gets or sets the discount cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Discount { get; set; }

        /// <summary>
        /// Gets or sets the deposit.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Deposit { get; set; }

        /// <summary>
        /// Gets or sets the Refund.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Refund { get; set; }

        /// <summary>
        /// Gets or sets the Rounding cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>o    
        public double? Rounding { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The module identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the receipt area type identifier.
        /// </summary>
        /// <value>
        /// The module master identifier.
        /// </value>
        public int ReceiptAreaTypeId { get; set; }

        public double RemovedAmount { get; set; }
    }
}
