﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The patient registration detail.
    /// </summary>
    public class PatientRegistrationDetail
    {
        /// <summary>
        /// Gets or sets the patient registration detail identifier.
        /// </summary>
        /// <value>
        /// The patient registration detail identifier.
        /// </value>
        [Key, Identity]
        public int PatientRegistrationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the patient registration charge identifier.
        /// </summary>
        /// <value>
        /// The patient registration charge identifier.
        /// </value>
        public double Charge { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the type of the pay.
        /// </summary>
        /// <value>
        /// The type of the pay.
        /// </value>
        public int PayTypeId { get; set; }
    }
}
