﻿namespace Hims.Domain.Entities.Vaccine
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The vaccine group.
    /// </summary>
    public class VaccineGroup
    {
        /// <summary>
        /// Gets or sets the vaccine group identifier.
        /// </summary>
        /// <value>
        /// The vaccine group identifier.
        /// </value>
        [Key, Identity]
        public int VaccineGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the vaccine group.
        /// </summary>
        /// <value>
        /// The name of the vaccine group.
        /// </value>
        public string VaccineGroupName { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
    }
}
