﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The purchase bill detail model.
    /// </summary>
    public class PurchaseBillDetailModel
    {
        /// <summary>
        /// Gets or sets the pharmacy purchase detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy purchase detail identifier.
        /// </value>
        public int PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy purchase header identifier.
        /// </value>
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax identifier.
        /// </summary>
        /// <value>
        /// The tax identifier.
        /// </value>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the purchase order detail identifier.
        /// </summary>
        /// <value>
        /// The purchase order detail identifier.
        /// </value>
        public long? PurchaseOrderDetailId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int? Free { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        /// <value>
        /// The tax per item.
        /// </value>
        public int TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        /// <value>
        /// The discount per item.
        /// </value>
        public int DiscountPerItem { get; set; } = 0;

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        /// <value>
        /// The total.
        /// </value>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        /// <value>
        /// The tax amount.
        /// </value>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        /// <value>
        /// The tax percentage.
        /// </value>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is expiry.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is expiry; otherwise, <c>false</c>.
        /// </value>
        public bool IsExpiry { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is igst.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is igst; otherwise, <c>false</c>.
        /// </value>
        public bool IsIGST { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is SGST.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is SGST; otherwise, <c>false</c>.
        /// </value>
        public bool IsSGST { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the type of the GST.
        /// </summary>
        /// <value>
        /// The type of the GST.
        /// </value>
        public string GSTType { get; set; }

    }
}
