﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.ProviderSchedule
{

    /// <summary>
    /// The coupon.
    /// </summary>
    public class FilterViewModel
    {
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the expiry.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the Department Id.
        /// </summary>

        public int DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public int[] AvailableDays { get; set; }

        /// <summary>
        /// Gets or sets the available date.
        /// </summary>
        public string AvailableDate { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public string Duration { get; set; }

        /// <summary>
        /// Gets or sets the availability
        /// </summary>
        public string Availability { get; set; }

        /// <summary>
        /// Gets or sets specializationId
        /// </summary>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string  SpecializationName {get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the availability
        /// </summary>
        public string StartDate { get; set; }

        /// <summary>
        /// Gets or sets the availability
        /// </summary>
        public string EndDate { get; set; }

        /// <summary>
        /// Gets or sets the availability
        /// </summary>
        public string StartTime { get; set; }

        /// <summary>
        /// Gets or sets the availability
        /// </summary>
        public string EndTime { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int ProviderAvailabilitySlotId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int FreeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int FreeFollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the available day.
        /// </summary>
        public string AvailableDay { get; set; }

        /// <summary>
        /// Gets or sets the availability duration.
        /// </summary>
        public int AvailabilityDuration { get; set; }

    }

    /// <summary>
    /// The duration.
    /// </summary>
    public class Duration
    {
        /// <summary>
        /// Gets or sets the type id.
        /// </summary>
        public int TypeId { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int Value { get; set; }
    }

    /// <summary>
    /// The availability.
    /// </summary>
    public class Availability 
    {
        /// <summary>
        /// Gets or sets the day.
        /// </summary>
        public int Day { get; set; }

        /// <summary>
        /// Gets or sets the slots.
        /// </summary>
        public List<Slots> Slots { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public List<ChargeType> ChargeType { get; set; }
    }

    /// <summary>
    /// The slots.
    /// </summary>
    public class Slots
    { 
        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string FromTime { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string ToTime { get; set; }
    }

    /// <summary>
    /// The charge type.
    /// </summary>
    public class ChargeType
    {
        /// <summary>
        /// Gets or sets the type id.
        /// </summary>
        public int TypeId { get; set; }

        /// <summary>
        /// Gets or sets name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int Value { get; set; }
    }
}
