﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Medication = Shared.UserModels.ProgressReport.Medication;
    using Timeline = Shared.UserModels.ProgressReport.Timeline;
    using MedicationInfo = Shared.UserModels.ProgressReport.MedicationInfo;
    using General = Shared.UserModels.ProgressReport.General;
    using System;
    using Diet = Shared.UserModels.ProgressReport.Diet;
    /// <summary> The ChatService interface.</summary>
    public interface IProgressReportService
    {
        /// <summary>
        /// Fetches the top admission ids asynchronous.
        /// </summary>
        /// <returns>
        ///   <br />
        /// </returns>
        Task<IEnumerable<int>> FetchTopAdmissionIdsAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the medication information asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<MedicationInfo.MedicationFetchModel>> FetchMedicationInfoAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the notes count asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> FetchNotesCountAsync(General.FilterModel model);

        /// <summary>
        /// Fetches the vitals count asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> FetchVitalsCountAsync(General.FilterModel model);

        /// <summary>
        /// Fetches the assessments count asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> FetchAssessmentsCountAsync(General.FilterModel model);

        /// <summary>
        /// Fetches the lab count asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> FetchLabCountAsync(General.FilterModel model);

        /// <summary>
        /// Fetches the medication count asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> FetchMedicationCountAsync(General.FilterModel model);

        /// <summary>
        /// Fetches all timeline asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Timeline.MedicationAllViewModel>> FetchAllTimelineAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the lab dates asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DateTime>> FetchLabDatesAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the note dates asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DateTime>> FetchNoteDatesAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the assessments dates asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DateTime>> FetchAssessmentsDatesAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the vitals dates asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DateTime>> FetchVitalsDatesAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the timeline slots asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <param name="date">The date.</param>
        /// <returns></returns>
        Task<IEnumerable<Timeline.ViewModel>> FetchTimelineSlotsAsync(List<int> model, DateTime date);

        /// <summary>
        /// Fetches the timeline asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Timeline.MedicationViewModel>> FetchTimelineAsync(Medication.FilterModel model);

        /// <summary>
        /// Adds the medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddMedicationAsync(Medication.InsertModel model);

        /// <summary>
        /// Adds the medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateMedicationAsync(Medication.UpdateModel model);

        /// <summary>
        /// Stops the medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> StopMedicationAsync(Medication.StopModel model);
        /// <summary>
        /// Stops the medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteMedicationAsync(Medication.DeleteModel model);
        /// <summary>
        /// Fetches the medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Medication.ViewModel>> FetchMedicationAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the master medications asynchronous.
        /// </summary>
        /// <param name="term">The term.</param>
        /// <returns></returns>
        Task<IEnumerable<Medication.MasterViewModel>> FetchMasterMedicationsAsync(string term);

        /// <summary>
        /// Fetches the master medications asynchronous.
        /// </summary>
        /// <param name="term">The term.</param>
        /// <returns></returns>
        Task<IEnumerable<Diet.MasterViewModel>> FetchMealTypeAsync(string term);

        /// <summary>
        /// Fetches the instructions asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Medication.InstructionViewModel>> FetchInstructionsAsync();

        /// <summary>
        /// Takes the medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> TakeMedicationAsync(List<Medication.TakeModel> model);

        /// <summary>
        /// Fetches the medication timeline asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Medication.TimelineViewModel>> FetchMedicationTimelineAsync(Medication.TimelineFilterModel model);

        /// <summary>
        /// Fetches the medication dates asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<Medication.DatesViewModel> FetchMedicationDatesAsync(Medication.FilterModel model);

        /// <summary>
        /// Fetches the indent medication dates asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Medication.IndentMedicinesViewModel>> FetchIndentMedicationDatesAsync(Medication.FilterModel model);
    }
}
