﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using System;

    using Hims.Shared.UserModels;
    using System.Collections.Generic;
    using Hims.Shared.UserModels.Scan.ScanTest;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Laboratory;

    /// <summary>
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IScanTestService
    {



        /// <summary>
        /// The add ob encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ScanTestInsertModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ScanTestInsertModel model);

        /// <summary>
        /// The fetch alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ScanTestMasterModel>> FetchAllScanTests(ScanTestMasterModel model);

        /// <summary>
        /// The fetch alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ScanTestMasterModel>> FetchAllAsync(ScanTestMasterModel model);

        /// <summary>
        /// The fetch alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ScanTestMasterModel>> FetchAltScanTests(ScanTestMasterModel model);

        /// <summary>
        /// The fetch import test async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ScanTestMasterModel>> FetchImportTestsAsync(ScanTestMasterModel model);

        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(ScanTestMasterModel model);


        /// <summary>
        /// The modify lab async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyImportTestAsync(TestImportModel model);

        /// <summary>
        /// Fetches all scan tests asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanTestMasterModel>> FetchAllScanTestsAsync(ScanTestMasterModel model);
        /// <summary>
        /// Fetches all scan tests asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanTestMasterModel>> FetchAllScanTestCodesAsync(ScanTestMasterModel model);

        /// <summary>
        /// Fetches all surgery asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanTestMasterServiceModel>> FetchAllScanAsync(ScanTestMasterServiceModel model);
    }
}
