﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Helpers;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.Library.Helpers;
using Hims.Shared.UserModels;
using Hims.Shared.UserModels.OBEncounter;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using GeneticSpecialityEncounter = Hims.Domain.Entities.GeneticSpecialityEncounter;

namespace Hims.Infrastructure.Services
{
    public class GeneticSpecialityEncounterService : IGeneticSpecialityEncounterService
    {
 
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

       

        public GeneticSpecialityEncounterService(  IUnitOfWork unitOfWork )
        {
          
            this.unitOfWork = unitOfWork; 
        }
        public async Task<int> AddAsync(GeneticSpecialityEncounterModel model)
        {
            var response = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"select count(*) from ""GeneticSpecialityEncounter"" where ""AppointmentId"" ={model.AppointmentId}");
            GeneticSpecialityEncounter geneticSpeciality = new GeneticSpecialityEncounter
            {
                AppointmentId = (int)model.AppointmentId,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
                Active = true,                
            };
            switch (model.Type)
            {
                case GeneticSpecialEncounterType.SpecialFeaturesPage:
                    geneticSpeciality.SpecialFeaturesPage = model.JsonString;
                    break;
                case GeneticSpecialEncounterType.GeneticVisit:
                    geneticSpeciality.GeneticVisit = model.JsonString;
                    break;
                case GeneticSpecialEncounterType.OutsideTest:
                    geneticSpeciality.OutsideTest = model.JsonString;
                    break;
            }

            var result = await this.unitOfWork.GeneticSpecialityEncounter.InsertAsync(geneticSpeciality);
            return result;
            
           
           

        }
        public async Task<int> UpdateAsync(GeneticSpecialityEncounterModel model)
        {

            var geneticencounter = this.unitOfWork.GeneticSpecialityEncounter.Find(s => s.AppointmentId == model.AppointmentId);
            if (geneticencounter == null)
            {
                return -2;
            }
            geneticencounter.ModifiedBy = (int)model.ModifiedBy;
            geneticencounter.ModifiedDate = DateTime.Now;
            switch (model.Type)
            {

                case GeneticSpecialEncounterType.SpecialFeaturesPage:
                    geneticencounter.SpecialFeaturesPage = model.JsonString;
                    break;
                case GeneticSpecialEncounterType.GeneticVisit:
                    geneticencounter.GeneticVisit = model.JsonString;
                    break;
                case GeneticSpecialEncounterType.OutsideTest:
                    geneticencounter.OutsideTest = model.JsonString;
                    break;
            }
            var result = await this.unitOfWork.GeneticSpecialityEncounter.UpdateAsync(geneticencounter);
            return result;
        }
   

        public async Task<GeneticSpecialityEncounterModel> FindDashboardAsync(GeneticSpecialityEncounterModel model)
        {

            
            string where = "where 1=1";
            if (model.AppointmentId > 0)
            {
                where += $@" and ""AppointmentId""={model.AppointmentId}";
            }
            
               var query = $@" select * from ""GeneticSpecialityEncounter"" {where}";


            return await this.unitOfWork.Current.QueryFirstOrDefaultAsync<GeneticSpecialityEncounterModel>(query);
           
        }

        public async Task<int> CheckExisted(int appointmentId)
        {
          return await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"select count(*) from ""GeneticSpecialityEncounter"" where ""AppointmentId"" ={appointmentId}");

        }
    }
}
