﻿namespace Hims.Domain.Entities.Vendors
{
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The purchase order detail.
    /// </summary>
    [Table("PurchaseOrderDetail", Schema = "vendors")]
    public class PurchaseOrderDetail
    {
        /// <summary>
        /// Gets or sets the purchase order detail identifier.
        /// </summary>
        /// <value>
        /// The purchase order detail identifier.
        /// </value>
        [Key,Identity]
        public long PurchaseOrderDetailId { get; set; }

        /// <summary>
        /// Gets or sets the purchase order header identifier.
        /// </summary>
        /// <value>
        /// The purchase order header identifier.
        /// </value>
        public long PurchaseOrderHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int Free { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        /// <value>
        /// The tax amount.
        /// </value>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is added by GRN.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is added by GRN; otherwise, <c>false</c>.
        /// </value>
        public bool IsAddedByGrn { get; set; }
    }
}
