﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.VitalType;
    using Resource = Hims.Shared.UserModels.UnitType;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IVitalTypeService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);
        

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsertModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="id">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(DeleteModel id);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="id">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>

        Task<string> FindNameByVitalTypeId(int id);

        /// <summary>
        /// Fetches the unit type asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource.ViewModel>> FetchUnitTypeAsync();
    }
}
