﻿namespace Hims.Infrastructure.Configurations
{
    using Domain.Configurations;

    /// <inheritdoc />
    public class ApplicationConfiguration : IApplicationConfiguration
    {
        /// <inheritdoc />
        public string Version { get; set; }

        /// <inheritdoc />
        public bool Maintenance { get; set; }

        /// <inheritdoc />
        public string PaymentLink { get; set; }

        /// <inheritdoc />
        public string CreatePasswordLink { get; set; }

        /// <inheritdoc />
        public string ResetPasswordLink { get; set; }

        /// <inheritdoc />
        public string MailTemplatesImagesLink { get; set; }

        /// <inheritdoc />
        public string DefaultEmail { get; set; }

        /// <inheritdoc />
        public string Email { get; set; }

        /// <inheritdoc />
        public string DefaultMobile { get; set; }

        /// <inheritdoc />
        public string BaseUrl { get; set; }

        /// <inheritdoc />
        public string APILink { get; set; }

        /// <inheritdoc />
        public string IOSAppLink { get; set; }

        /// <inheritdoc />
        public string AndroidAppLink { get; set; }

        /// <inheritdoc />
        public string WebsiteLink { get; set; }

        /// <inheritdoc />
        public string ProviderPortalLink { get; set; }

        /// <inheritdoc />
        public string AdminPortalLink { get; set; }

        /// <inheritdoc />
        public string StatesUrl { get; set; }

        /// <inheritdoc />
        public bool AllowSMSSending { get; set; }

        /// <inheritdoc />
        public bool AllowVideoCall { get; set; }

        /// <inheritdoc />
        public string FrontEndLink { get; set; }

        /// <inheritdoc />
        public string TinyUrlLink { get; set; }

        /// <summary>
        /// Gets or sets the tiny URL authentication token.
        /// </summary>
        /// <value>
        /// The tiny URL authentication token.
        /// </value>
        public string TinyUrlAuthToken { get; set; }

        /// <summary>
        /// Gets the firebase database.
        /// </summary>
        /// <value>
        /// The firebase database.
        /// </value>
        public string FirebaseDatabase { get; set; }

        /// <summary>
        /// Gets the firebase authentication key.
        /// </summary>
        /// <value>
        /// The firebase authentication key.
        /// </value>
        public string FirebaseAuthKey { get; set; }

        /// <inheritdoc />
        public string SalucroPaymentLink { get; set; }

        /// <inheritdoc />
        public string SalucroPatientPaymentLink { get; set; }
    }
}