﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The patient filter model.
    /// </summary>
    public class PharmacyReportFilterModel
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public string? SaleDate { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int TotalTaxes { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int TotalDiscount { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int TotalNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }


        /// <summary>
        /// Gets or sets to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string? ProductName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string? GenericName { get; set; }

        /// <summary>
        /// Gets or sets to date.
        /// </summary>
        public string? PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets to PayTypeId.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets to PaymentType.
        /// </summary>
        public string? PaymentType { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string? CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the retail store name.
        /// </summary>
        public string? RetailStoreName { get; set; }

        /// <summary>
        /// Gets or sets the WareHouse name.
        /// </summary>
        public string? WareHouseName { get; set; }
    }
}
