﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    /// <summary>
    /// The anc card generation
    /// </summary>
    public class ANCCardGeneration
    {
        /// <summary>
        /// Gets or sets the anc card generation identifier.
        /// </summary>
        [Key, Identity]
        public int ANCCardGenerationId { get; set; }

        /// <summary>
        /// Gets or sets department
        /// </summary>
        public string? Department { get; set; }
        /// <summary>
        /// Gets or sets anc no.
        /// </summary>
        public string? ANCNo { get; set; }
        /// <summary>
        /// Gets or sets the husband name.
        /// </summary>
        public string? HusbandName { get; set; }
      
        /// <summary>
        /// Gets or sets the remark.
        /// </summary>
        public string? Remarks { get; set; }
        /// <summary>
        /// Gets or sets the registration date.
        /// </summary>
        public string? RegistrationDate { get; set; }
        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the patient Id.
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// Gets or sets the husband age.
        /// </summary>
        public int? HusbandAge { get; set; }
        /// <summary>
        /// Gets or sets anc no exist.
        /// </summary>
        public string? ANCNoExists { get; set; }

        public string? ConsultantDoctor { get; set; }

    }
}
