﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class DietGuidLines
    {
        /// <summary>
        /// Gets or sets the diet guidlines id.
        /// </summary>
        [Key, Identity]
        public int DietGuidLinesId { get; set; }
        public string DietGuidLinesName { get; set; }
        public string DocumentUrl { get; set; }
        /// <summary>
        /// Gets or sets the pdf link.
        /// </summary>
        public string PdfLink { get; set; }
        public int? DietTypeId { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public float Size { get; set; }
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string ContentType { get; set; }
    }
}
