﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class FinalBillInsurance
    {
        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        [Key, Identity]
        public int FinalBillInsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int FinalBillId { get; set; }

        /// <summary>
        /// Gets or sets the coupon type.
        /// </summary>
        public int  InsuranceForAdmissionId { get; set; }


        /// <summary>
        /// Gets or sets the valid from.
        /// </summary>
        [IgnoreUpdate]
        public DateTime ClaimDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        
        /// <summary>
        /// Gets or sets the allowed per user.
        /// </summary>
        public int? InsuranceClaimStatus { get; set; }
    }
}
