﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab transfer detail.
    /// </summary>
    public class LabTransferDetail
    {
        /// <summary>
        /// Gets or sets the lab transfer detail identifier.
        /// </summary>
        /// <value>
        /// The lab transfer detail identifier.
        /// </value>
        [Key, Identity]
        public int LabTransferDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab transfer header identifier.
        /// </summary>
        /// <value>
        /// The lab transfer header identifier.
        /// </value>
        public int LabTransferHeaderId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection detail identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection detail identifier.
        /// </value>
        public int? LabSampleCollectionDetailId { get;set;}

        /// <summary>
        /// Gets or sets the received by.
        /// </summary>
        /// <value>
        /// The received by.
        /// </value>
        public int? ReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the received date.
        /// </summary>
        /// <value>
        /// The received date.
        /// </value>
        public DateTime? ReceivedDate { get; set; }

        /// <summary>
        /// Gets or sets the department received by.
        /// </summary>
        /// <value>
        /// The department received by.
        /// </value>
        public int? DepartmentReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the department received date.
        /// </summary>
        /// <value>
        /// The department received date.
        /// </value>
        public DateTime? DepartmentReceivedDate { get; set; }


    }
}
