﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Shared.Dapper.Attributes;

    /// <summary>
    /// The login.
    /// </summary>
    public class Login
    {
        /// <summary>
        /// Gets or sets the login id.
        /// </summary>
        [Key, Identity]
        public int LoginId { get; set; }

        /// <summary>
        /// Gets or sets the username.
        /// </summary>
        public string? Username { get; set; }

        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        public string? Password { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public string? DeviceType { get; set; }

        /// <summary>
        /// Gets or sets the device token.
        /// </summary>
        public string? DeviceToken { get; set; }

        /// <summary>
        /// Gets or sets the device id.
        /// </summary>
        public string? DeviceId { get; set; }

        /// <summary>
        /// Gets or sets the account types.
        /// </summary>
        public string? AccountTypes { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }
    }
}