﻿using Hims.Shared.Library.Enums;

namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    public class NotificationLog
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        [Key, Identity]
        public int NotificationLogId { get; set; }

        /// <summary>
        /// Gets or sets the to type id.
        /// </summary>
        public ToType ToTypeId { get; set; }

        /// <summary>
        /// Gets or sets the to type device ids id.
        /// </summary>
        public string DeviceIds { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the response.
        /// </summary>
        public string Response { get; set; }

        /// <summary>
        /// Gets or sets the data.
        /// </summary>
        public string Data { get; set; }
        public NotificationType? NotificationTypeId { get; set; }
        public int? AccountId { get; set; }
    }
}